<?php

namespace App\Modes\Task;

use Illuminate\Database\Eloquent\Model;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;

    public function cases()
    {
        return $this->hasMany('CaseTask', 'task_id');
    }

    public function notes()
    {
        return $this->hasMany('Notes', 'task_id');
    }

    public function documents()
    {
        return $this->hasMany('Document', 'task_id');
    }

    public function users()
    {
        return $this->hasMany('TaskUsers', 'task_id');
    }

    public function reminders()
    {
        return $this->hasMany('TaskReminders', 'task_id');
    }

    public function doctors()
    {
        return $this->hasMany('TaskDoctor', 'task_id');
    }

}